﻿/**
 * 成绩管理js
 * 
 * @since 2015/06/29
 * @author Limeng
 */
$(function() {
	
	creatGrid();
	
	//导出条件表单
	$('#excelForm').form({
		url : baseUrl +"/admin/T070/exportExamResultsExcel.html",
		success : function(data) {
			$.messager.alert('hint',data,'info');
		}
	});
	// 职位分类
	$('#positionCombox').combobox({
		url : baseUrl +'/admin/U060/findPosition.html',
		panelHeight : 300,
		editable : false,
		valueField : 'positionid',
		textField : 'name'
	});
	//查看窗口
	$('#seewin').window({    
		width : 800,
		height : 500,
		draggable : false,
		resizable : false,
		collapsible : false,
		minimizable : true,
		maximizable : true,
		closable : true,
		closed : true,
		inline : true,
		maximized:true,
		title : 'view exam paper',
		modal : true   
	});
	$('#updSorce').dialog({
		// iconCls:'icon-save',
		title : 'modify score',
		closed : true,
		modal : true,
		shadow : false
	});
	$('#searchUserGroup').combotree({
		multiple : false,
		checkbox : false,
		lines : true,
//		panelWidth:'auto',
		panelHeight:'500',
		panelMinWidth:200,
		panelMaxWidth:300,
		panelMaxHeight:500,
		animate : true,
		editable : false,
		url : baseUrl + '/admin/U030/findGroupAddALL.html',
		required : false,
		onHidePanel : getChildren
//		onShowPanel:function(){
//			$('#searchUserGroup').combotree('panel').panel({bodyCls:'panel_body_class'});
//		}
	});
});
//获得所选用户组节点及子节点,暂未调用
function getChildren() {
	var grouptree = $('#searchUserGroup').combotree('tree');
	var n = grouptree.tree('getSelected');
	var ids=n.id;
	var items=n.children;
	if(items!=null){
		var children = grouptree.tree('getChildren', n.target);
		for(var i=0;i<children.length;i++){
			var item=children[i];
			ids=ids+","+item.id;
		}
	}
	$("#groupids").val(ids);
}
function creatGrid() {
	$('#itemlist').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : true,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50, 100 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl +"/admin/T070/listExamResults.html",
		toolbar : '#tbar',
		frozenColumns : [ [ {
			field : 'select',
			title : 'select',
			width : 50,
			checkbox : true
		} ] ],
		columns : [ [ {
			field : 'ksname',
			title : 'exam name',
			width : 120,
			sortable : true,
			halign: 'center',
			align : 'left'
		}, {
			
			field : 'kstimes',
			title : 'exam times',
			width : 50,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'sjtotalsorce',
			title : 'exam paper total score',
			width : 50,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'kssorce',
			title : 'exam score',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right',
			formatter : fmsorce
		}, {
			field : 'startTime',
			title : 'exam starting time',
			width : 120,
			sortable : true,
			formatter : fmdate,
			halign: 'center',
			align : 'center'
		}, {
			field : 'endTime',
			title : 'exam ending time',
			width :120,
			formatter : fmdate,
			sortable : true,
			halign: 'center',
			align : 'center'
		},{
			field : 'SJC',
			title : 'exam lasts time',
			width : 60,
			sortable : true,
			halign: 'center',
			align : 'right'
		},{
			field : 'ksuserName',
			title : 'examinee user name',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'ksrealName',
			title : 'examinee real name',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'examcard',
			title : 'examinee education background',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'positionname',
			title : 'examinee position',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'groupName',
			title : 'examinee group name',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'okrateState',
			title : 'pass or fail',
			width : 50,
			sortable : true,
			align : 'left'
		}, {
			field : 'manage',
			title : 'manage',
			align : 'center',
			width : 150,
			formatter : fmup
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.see_chengji').linkbutton({
				iconCls : 'icon-search',
				plain : true
			});
			$('.out_chengji').linkbutton({
				iconCls : 'icon-word',
				plain : true
			});
			$('.del_chengji').linkbutton({
				iconCls : 'icon-no',
				plain : true
			});
		}
	});

}
function fmup(value, rowData, rowIndex) {
	var id = rowData.ksuid;
	var sid=rowData.shijuanid;
	var ksuserName = rowData.ksuserName;
	var ksname = rowData.ksname;
	var kstimes = rowData.kstimes;
	var sjtotalsorce = rowData.sjtotalsorce;
	var kssorce = rowData.kssorce;
	var startTime = rowData.startTime;
	var endTime = rowData.endTime;
	var str="<a onclick='openSeeWin("+ id+")' class='see_chengji'>see</a>";
	str += "<a onclick='outWord("+ id+");' class='out_chengji' >derive</a>";
	str += "<a onclick='delCjById("+ id+");' class='del_chengji' >delete</a>";
	return str;
}
//======================================查看试卷=================================//
//打开查看窗口
function openSeeWin(id) {
	window.parent.closeTabByTitle("graded exam paper preview");
	window.parent.openTab("graded exam paper preview", baseUrl+"/admin/T070/examResultsPreview.html?id="+id);
}
function getData(id){
	alert(id);
	$.post(baseUrl +"/admin/T070/getExamPaper.html", {
	id : id
	}, function(data) {	
		loadSjInfo(data);
	}, "json");
}
function loadSjInfo(data){
	//卷子名
	var sjname=data.kstitle;
	//alert(sjname);
	//固定题
	var gud_shitimix=eval("("+data.d_shitimix+")");
	var gud_shitimix=eval("("+gud_shitimix.data+")");
//	//固答案
//	var gud_daandata=eval("("+data.daandata+")");
//	//alert(gud_daandata);
//	//随机题
//	var shuij_xtmix=eval("("+data.d_xtmix+")");
//	//alert(shuij_xtmix);
//	//随答案
//	var shuij_rdaandata=eval("("+data.rdaandata+")");
//	//alert(shuij_rdaandata);
	//容器
	var C=$("#seewin");
	C.append(sjname);
	for(var i=0;i<gud_shitimix.length;i++){
		var html='<p>';
		html+=gud_shitimix[i].title;
		html+='</p>';
		C.append(html);
	}
	
	
		
	
}
//======================================查看结束=================================//
//导出
function outWord(id){
	
	window.location.href=baseUrl +"/admin/T070/exportWord.html?id="+id;
	
}
//日期转换
function fmdate(value, rowData, rowIndex) {
	// fmtLongDate--common.js
	if (value != null && value != '') {
		return fmtLongDate(new Date(value));
	}
	return "";
}

//查询
function seachChengjiByParam() {
	//给隐藏表单赋值
	var ksname=$("#ksname").val();
	$("#exksname").attr("value",ksname);
	var ksusername=$("#ksusername").val();
	$("#exksusername").attr("value",ksusername);
	var search_examcard = $("#examcardlike").val();
	var search_positionid = $('#positionCombox').combobox('getValue');
	$("#exExamcard").val(search_examcard);
	$("#expositionid").val(search_positionid);
	var search_groupid = $('#groupids').val();
	$("#exgroupid").val(search_groupid);
	var param = {
		ksname : ksname,
		ksusername:ksusername,
		examcard:search_examcard,
		positionid:search_positionid,
		groupid : search_groupid
	};
	$('#itemlist').datagrid('load', param);
}
//刷新
function reloadGrid() {
	$('#itemlist').datagrid('clearSelections');
	$('#itemlist').datagrid('reload');
}

//导出Excel
function exportExcel() {
	$('#excelForm').submit();
	return false;
}
//删除用户
function delCjById(id) {
	var items_id = new Array();
	items_id.push(id);
	$.messager.confirm('delete hint', 'make sure to delete the selected score?', function(r) {
		if (r) {
			$.post(baseUrl +"/admin/T070/removeExamResults.html", {
				ids : items_id
			}, function(data) {
				if (data > 0) {
					msgShow('delete success!');
					reloadGrid();
				} else {
					msgShow('delete failure,please try again later');
					reloadGrid();
				}
			}, "json");
		}else{
			$('#itemlist').datagrid('clearSelections');
		}
	});
}
//删除用户提示
function delCjMessage() {
	$.messager.confirm('delete hint', 'make sure to delete the selected score?', function(r) {
		if (r) {
			delCj();
		}else{
			$('#itemlist').datagrid('clearSelections');
		}
	});
}
//删除用户
function delCj() {
	var items_id = new Array();
	var items = $('#itemlist').datagrid('getSelections');
	if (items.length <= 0) {
		$.messager.alert('hint', 'please select the score need deleted', 'info');
		return;
	}
	// 获取选中用户的ID，并组成集合
	for ( var i = 0; i < items.length; i++) {
		items_id.push(items[i].ksuid);
	}
	$.post(baseUrl +"/admin/T070/removeExamResults.html", {
		ids : items_id
	}, function(data) {
		if (data > 0) {
			msgShow('delete success!');
			reloadGrid();
		} else {
			msgShow('delete failure,please try again later');
			reloadGrid();
		}
	}, "json");
}
// 批量导出word成绩
function downloadRar() {
	var items_id = new Array();
	var items = $('#itemlist').datagrid('getSelections');
	if (items.length <= 0) {
		$.messager.alert('hint', 'please select the score need derived', 'info');
		return;
	}
	var ids = items[0].ksuid;
	// 获取选中用户的ID，并组成集合
	for ( var i = 1; i < items.length; i++) {
		ids = ids + "," + items[i].ksuid;
	}
	window.location.href = baseUrl +"/admin/T070/downloadRar.html?ids="+ids+"";
}
//修改成绩
function fmsorce(value, rowData, rowIndex) {
	return rowData.kssorce + "<a href='javascript:;' class='blue_color_a' onclick='updSorce(" +rowData.ksuid + "," + rowData.kssorce 
			+ ","+rowData.sjtotalsorce+");'>" + " modify score</a>";
}
//弹出修改成绩
function updSorce(ksuid, kssorce,sjtotalsorce) {
	$("#ksuid").val(ksuid);
	$("#sjtotalsorce").val(sjtotalsorce);
	$("#sorce").numberbox("setValue", kssorce);
	$('#updSorce').dialog('open');
}
// 保存修改成绩
function saveSorce() {
	var ksuid = $('#ksuid').val();
	var sorce = $('#sorce').val();
	var sjtotalsorce = $('#sjtotalsorce').val();
	if(eval(sorce)>eval(sjtotalsorce)){
		alert("The modified score is greater than the total score");
		return;
	}
	$.post(baseUrl +"/admin/T070/updateSorce.html", {
		ksuid : ksuid,
		sorce : sorce
	}, function(data) {
		if (data == 0) {
			msgShow('operating fails, please try again later!');
			return;
		}
		msgShow('operating succeed!');
		$('#updSorce').dialog('close');
		$('#itemlist').datagrid('reload');
	}, "json");
}